/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.system.action;

import java.io.Serializable;
import java.util.Comparator;

import jp.mosp.common.MosPAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.system.dao.MSyozokuDao;
import jp.mosp.system.dto.MSyozokuDto;
import jp.mosp.system.vo.SyozokuMasterListVo;

public class SyozokuMasterListAction extends MosPAction {

	// R}h
	private static final String CMD_SYOZOKU_LIST_SHOW       = "S2100";	// \
	private static final String CMD_SYOZOKU_LIST_SEARCH     = "S2101";	// 
	private static final String CMD_SYOZOKU_LIST_RE_SEARCH  = "S2102";	// Č
	private static final String CMD_SYOZOKU_TYPE_LIST_SORT  = "S2103";	// \[g

	/**
	 * RXgN^
	 */
	public SyozokuMasterListAction() {
		super();
	}

	public void action() throws Exception {
		// DBRlNV擾
		getConnection();
		// SYSTEMmF
		confirmSystemAuth();
		// VO̎擾
		SyozokuMasterListVo vo;
		Object obj = session.getAttribute(MospConst.ATT_FORMER_VO);
		if (obj instanceof SyozokuMasterListVo) {
			vo = (SyozokuMasterListVo) obj;
		} else {
			vo = new SyozokuMasterListVo();
		}
		vo.clearMessage();
		vo.clearErrField();
		vo.initVo(cfg, msg, cmd, aspUser, user);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		session.setAttribute(MospConst.ATT_FORMER_VO, vo);
		// R}h̏
		if (cmd.equals(CMD_SYOZOKU_LIST_SHOW)) {
			// lɃZbg	
			vo.setSearchmode(SyozokuMasterListVo.SEARCH_OFF);
		} else if (cmd.equals(CMD_SYOZOKU_LIST_SEARCH )) {
			// 
			vo.setParams(request);
			searchSyozokuMasterList(vo);
			vo.setFormerKey(vo.KEY_S_CODE);
			vo.setIsAscending(true);
			vo.initListInfo();
			// ɃZbg
			vo.setSearchmode(SyozokuMasterListVo.SEARCH_ON);
		} else if (cmd.equals(CMD_SYOZOKU_LIST_RE_SEARCH)) {
			// Č
			if (vo.getSearchmode() == SyozokuMasterListVo.SEARCH_ON) {
				session.removeAttribute(MospConst.ATT_DTO);
				searchSyozokuMasterList(vo);
				vo.setPageButton();
				sortList(vo);
			}			
		} else if (cmd.equals(CMD_SYOZOKU_TYPE_LIST_SORT)) {
			// \[g
			sortList(key1, vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}

	/**
	 * Xg
	 * @param vo CodeListVoCX^X
	 * @throws Exception
	 */
	private void searchSyozokuMasterList(SyozokuMasterListVo vo) throws Exception {
		MSyozokuDao dao = new MSyozokuDao();
		dao.initDao(cfg, cmd, aspUser, user, conn);
		vo.setFields(dao.findForCondition(vo.getTxtSCode(),vo.getTxtSName()));
		//ΏۂȂꍇ̃bZ[Wݒ
		if (vo.getEscArySCode().length == 0) {
			vo.addErrMessage(MospUtility.getMessage(msg, MospConst.MSG_NO_DATA, ""));
		}
	}

	/**
	 * \[g
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(String key, SyozokuMasterListVo vo) throws MospException {
		vo.sortList(key, getComparator(key, vo));
		vo.setFields(vo.getList());
	}

	/**
	 * \[g(VÕL[Ń\[g)
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private void sortList(SyozokuMasterListVo vo) throws MospException {
		vo.sortList(getComparator(vo.getFormerKey(), vo));
		vo.setFields(vo.getList());
	}

	/**
	 * rNX擾
	 * @param key \[gL[
	 * @param vo \[gΏList܂VO
	 * @throws MospException
	 */
	private Comparator<Object> getComparator(String key, SyozokuMasterListVo vo) throws MospException {
		Comparator<Object> comp = null;
		if (key.equals(vo.KEY_S_CODE)) {
			comp = new CompSyozokuCode();
		} else if (key.equals(vo.KEY_S_NAME)) {
			comp = new CompSyozokuName();
		} else {
			throw new MospException(MospConst.EX_SORTKEY_INVALID);
		}
		return comp;
	}

	/**
	 * R[hɂrNX
	 */
	protected static class CompSyozokuCode implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -1583394950071248662L;
		public int compare(Object obj1, Object obj2) {
			MSyozokuDto dto1 = (MSyozokuDto)obj1;
			MSyozokuDto dto2 = (MSyozokuDto)obj2;
			return dto1.getSCode().compareTo(dto2.getSCode());
		}
	}

	/**
	 * ɂrNX
	 */
	protected static class CompSyozokuName implements Comparator<Object>, Serializable {
		private static final long serialVersionUID = -5375772027347639889L;
		public int compare(Object obj1, Object obj2) {
			MSyozokuDto dto1 = (MSyozokuDto)obj1;
			MSyozokuDto dto2 = (MSyozokuDto)obj2;
			return dto1.getSName().compareTo(dto2.getSName());
		}
	}

}
